*Computation of MLD for two earnings measures, with and without respondents with missing information on covariates

*Tim Goedemé, 28/10/2020

/*

Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License. 
This file can be changed and re-shared for non-commercial use, as long as our original work 
is recognised and the revised work is made available under the same conditions.

When using this do-file, please cite as:
Goedemé, T., Nolan, B., Paskov, M., & Weisstanner, D. (2021). 
Occupational Social Class and Earnings Inequality in Europe: A Comparative Assessment. 
In: Social Indicators Research. DOI: https://doi.org/10.1007/s11205-021-02746-z; https://timgoedeme.com/tools/esec-in-eu-silc/

This file makes use of the decomld command which I wrote for this paper,
but is not available online. Please get in touch if you would like to make use
of this command.

*/

*globals IS and SK dropped from list of countries

global place1 <<data directory ...\2020-04\>>
global place2 <<output directory ...\Estimations\>>
global countries AT BE BG CH CY CZ DE DK EE EL ES FI FR HR HU IE IT LT LU LV MT NL NO PL PT RO RS SE SI UK

*Estimations - 9 classes ONLY EU-SILC 2018

foreach ctry of global countries {
	di "`ctry'", _continue
	cap mat drop results	
	quietly {
		local year 2018
		cap use "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars2.dta", clear
		if _rc==0 {
			keep psu1 weight strata1 sub earns1 earns2 missers2 esec08
			
			svyset psu1 [pw=weight], strata(strata1)
			
			gen sub1 = sub
			gen sub2 = sub
			replace sub2 = 0 if missers2==1
			
			if regexm("DK DE NL MT EE BE CZ NO SE LU CH PT SI CY UK FR IT", "`ctry'")==1 replace sub2 = 0 if esec08==5 
			if "`ctry'"=="DK" replace sub2 = 0 if (esec08==5 | esec08==4)
			if "`ctry'"=="RO" replace sub2 = 0 if (esec08==6)
			
			
			forvalues sub=1/2 {
				forvalues x=1/2 {
					noi di "subpop:`sub': earnings:`x';", _continue
					decomld earns`x', na(temp1) group(esec08) subpop(sub`sub')
					local val=rowsof(temp1)
					cap mat drop tempmat
					forvalues row=1(1)`val' {
						mat def tempmat = nullmat(tempmat) \ `x', `sub'
					}
					mat colnames tempmat = earnings subpop
					mat def matje = temp1, tempmat
					mat def results = nullmat(results) \ matje

				}
			}
			di "."
			
		}
		clear
		svmat results, names(col)
		gen country="`ctry'"
		
		save "${place2}\Decomp_`ctry'_2.dta", replace // esec08
	}
}

*Putting estimations together

clear
foreach ctry of global countries {
	append using "${place2}\Decomp_`ctry'_2.dta"
}
save "${place2}\Decomp_Esec9_2018_2.dta", replace




******************************************************************************
*Estimations - 3 classes ONLY EU-SILC 2018

foreach ctry of global countries {
	di "`ctry'", _continue
	cap mat drop results	
	quietly {
		local year 2018
		cap use "${place1}\`ctry'\\`year'\c`ctry'`year'_addvars1.dta", clear
		if _rc==0 {
			drop age hydisp eqs hystd thresh60 arop60 actage active
			svyset psu1 [pw=weight], strata(strata1)
			
			gen sub1 = sub
			gen sub2 = sub
			replace sub2 = 0 if missers==1
			
			gen esec3=(esec08<3)
			replace esec3 = 2 if esec08>=3 & esec08<7
			replace esec3 = 3 if esec08>=7
			replace esec3 = . if esec08==.
			
			forvalues sub=1/2 {
				forvalues x=1/2 {
					noi di "subpop:`sub'; earnings:`x'", _continue
					decomld earns`x', na(temp1) group(esec3) subpop(sub`sub')
					local val=rowsof(temp1)
					cap mat drop tempmat
					forvalues row=1(1)`val' {
						mat def tempmat = nullmat(tempmat) \ `x', `sub'
					}
					mat colnames tempmat = earnings subpop
					mat def matje = temp1, tempmat
					mat def results = nullmat(results) \ matje

				}
			}
			di " "
			
		}
		clear
		svmat results, names(col)
		gen country="`ctry'"
		
		save "${place2}\Decomp_`ctry'_3.dta", replace // esec08
	}
}

*Putting estimations together

clear
foreach ctry of global countries {
	append using "${place2}\Decomp_`ctry'_3.dta"
}
save "${place2}\Decomp_Esec3_2018.dta", replace

*

